# 🚀 Guia de Hospedagem Localhost - Empreendedor MEI

## 📋 Pré-requisitos

### Software Necessário
1. **XAMPP** (já instalado em `C:\xampp`)
   - Versão recomendada: 7.4 ou superior
   - Inclui: Apache, MySQL, PHP, phpMyAdmin

2. **Navegador Web**
   - Chrome, Firefox, Edge (recomendado)

3. **Editor de Código** (opcional)
   - VS Code, PhpStorm, Sublime Text

## 🔧 Instalação e Configuração

### Passo 1: Verificar Instalação do XAMPP

1. Abra o **XAMPP Control Panel**
2. Verifique se os seguintes serviços estão disponíveis:
   - ✅ Apache
   - ✅ MySQL (opcional para este projeto)

### Passo 2: Localizar Diretório do Projeto

O projeto já está localizado em:
```
C:\xampp\htdocs\empreendedormei
```

Se não estiver, mova o projeto para este diretório.

### Passo 3: Iniciar Servidor Apache

1. No **XAMPP Control Panel**, clique em **Start** ao lado de **Apache**
2. Aguarde até aparecer a mensagem "Apache started"
3. A porta padrão é **80** (http://localhost)

### Passo 4: Verificar Configuração PHP

1. Abra o arquivo `C:\xampp\php\php.ini`
2. Verifique se a extensão `curl` está habilitada:
   ```ini
   extension=curl
   ```
3. Se estiver comentada (com `;`), remova o `;`:
   ```ini
   ;extension=curl  ❌ (comentado)
   extension=curl   ✅ (habilitado)
   ```
4. Reinicie o Apache no XAMPP Control Panel

### Passo 5: Testar Acesso ao Projeto

1. Abra seu navegador
2. Acesse uma das seguintes URLs:

   **Opção 1: Acesso à raiz (redireciona automaticamente)**
   ```
   http://localhost/empreendedormei/
   ```
   ou
   ```
   http://localhost/empreendedormei/index.php
   ```

   **Opção 2: Com CNPJ na URL**
   ```
   http://localhost/empreendedormei/a.php?cnpj=12345678000190
   ```

   **Opção 3: Sem parâmetro (usa dados fictícios)**
   ```
   http://localhost/empreendedormei/a.php
   ```

3. Você deve ver a tela de "Autenticando" e depois redirecionar para "Minha Conta"

> **Nota**: O arquivo `index.php` foi criado para redirecionar automaticamente para `a.php`. Se você acessar a raiz do projeto, será redirecionado automaticamente.

## 🌐 URLs do Projeto

### Páginas Principais

| Página | URL | Descrição |
|--------|-----|-----------|
| **Raiz do Projeto** | `http://localhost/empreendedormei/` | Redireciona para a.php |
| **Página Inicial** | `http://localhost/empreendedormei/a.php` | Consulta CNPJ e exibe status MEI |
| **Minha Conta** | `http://localhost/empreendedormei/minha-conta.php` | Página da conta do usuário |
| **Débitos** | `http://localhost/empreendedormei/debitos.html` | Lista de débitos DAS |
| **Aviso Pagamento** | `http://localhost/empreendedormei/aviso-pagamento.html` | Aviso legal antes do pagamento |
| **Loading** | `http://localhost/empreendedormei/loading.html` | Tela de carregamento |
| **Fatura PIX** | `http://localhost/empreendedormei/fatura.html` | Pagamento via PIX |

### APIs

| Endpoint | URL | Método | Descrição |
|----------|-----|--------|-----------|
| **Criar Pagamento** | `http://localhost/empreendedormei/api/create-payment.php?customer_cpf=...&customer_name=...` | GET | Cria pagamento PIX (mock) |
| **Status Pagamento** | `http://localhost/empreendedormei/api/get-payment.php?transactionId=...` | GET | Verifica status do pagamento (mock) |

## 🔍 Solução de Problemas

### Problema 1: Apache não inicia

**Sintomas**: Erro "Port 80 already in use" ou Apache não inicia

**Soluções**:
1. Verifique se outra aplicação está usando a porta 80:
   - Skype, IIS, outro servidor web
2. Altere a porta do Apache:
   - XAMPP Control Panel → Apache → Config → httpd.conf
   - Altere `Listen 80` para `Listen 8080`
   - Acesse via `http://localhost:8080/empreendedormei/a.php`

### Problema 2: Erro ao consultar CNPJ

**Sintomas**: Erro na página `a.php` ao consultar CNPJ

**Soluções**:
1. Verifique se a extensão `curl` está habilitada no PHP
2. Verifique conexão com a internet
3. O sistema usa a API OpenCNPJ (100 consultas por minuto) para consulta de CNPJ.

### Problema 3: Páginas não carregam (404)

**Sintomas**: Erro 404 ao acessar as páginas

**Soluções**:
1. Verifique se o projeto está em `C:\xampp\htdocs\empreendedormei`
2. Verifique se o Apache está rodando
3. Limpe o cache do navegador (Ctrl + F5)

### Problema 3.1: Erro "No Content" ou redirecionamento para URL externa

**Sintomas**: Ao acessar `http://localhost/empreendedormei/` aparece erro ou tenta acessar URL externa

**Solução**:
1. ✅ **JÁ CORRIGIDO**: Os arquivos `index.php` e `index.html` foram corrigidos
2. Se ainda ocorrer, acesse diretamente: `http://localhost/empreendedormei/a.php`
3. Verifique se o arquivo `.htaccess` existe e está configurado corretamente
4. Veja mais detalhes em: **[SOLUCAO_PROBLEMA.md](./SOLUCAO_PROBLEMA.md)**

### Problema 4: QR Code não aparece

**Sintomas**: QR Code não é gerado na página `fatura.html`

**Soluções**:
1. Verifique conexão com a internet (CDN do QR Code)
2. Abra o Console do Navegador (F12) para ver erros
3. Verifique se há dados no `localStorage`:
   ```javascript
   console.log(localStorage.getItem('currentTransaction'));
   ```

### Problema 5: CSS não carrega

**Sintomas**: Página sem estilização

**Soluções**:
1. Verifique se o Tailwind CSS está carregando (via CDN)
2. Verifique conexão com a internet
3. Abra o Console do Navegador (F12) → Network → verifique se há erros 404

## 🧪 Testando o Sistema

### Fluxo Completo de Teste

1. **Acesse a página inicial**:
   ```
   http://localhost/empreendedormei/a.php?cnpj=12345678000190
   ```

2. **Aguarde o redirecionamento** para `minha-conta.php`

3. **Clique em "Ver meus débitos"** → Redireciona para `debitos.html`

4. **Clique em "Regularizar agora"** → Redireciona para `aviso-pagamento.html`

5. **Clique em "Emitir DAS"** → Redireciona para `loading.html`

6. **Aguarde a geração do PIX** → Redireciona para `fatura.html`

7. **Verifique o QR Code e código PIX** na página `fatura.html`

### Testando APIs Manualmente

#### Teste 1: Criar Pagamento
```
http://localhost/empreendedormei/api/create-payment.php?customer_cpf=12345678000190&customer_name=EMPRESA%20TESTE&customer_email=teste@email.com&customer_phone=61999999999
```

**Resposta esperada**:
```json
{
  "pixQr": "...",
  "amount": 16180,
  "status": 200,
  "pixCode": "...",
  "transaction_id": "..."
}
```

#### Teste 2: Verificar Status
```
http://localhost/empreendedormei/api/get-payment.php?transactionId=c2a51b25-828c-42ec-829b-dec8c2318a9d
```

**Resposta esperada**:
```json
[
  {
    "id": "c2a51b25-828c-42ec-829b-dec8c2318a9d",
    "amount": "16180",
    "status": "waiting_payment"
  }
]
```

## 📝 Configurações Adicionais

### Habilitar Mod_Rewrite (Opcional)

Se precisar de URLs amigáveis no futuro:

1. Abra `C:\xampp\apache\conf\httpd.conf`
2. Localize e descomente:
   ```apache
   LoadModule rewrite_module modules/mod_rewrite.so
   ```
3. Reinicie o Apache

### Configurar Virtual Host (Opcional)

Para acessar via `http://empreendedormei.local`:

1. Abra `C:\xampp\apache\conf\extra\httpd-vhosts.conf`
2. Adicione:
   ```apache
   <VirtualHost *:80>
       ServerName empreendedormei.local
       DocumentRoot "C:/xampp/htdocs/empreendedormei"
       <Directory "C:/xampp/htdocs/empreendedormei">
           Options Indexes FollowSymLinks
           AllowOverride All
           Require all granted
       </Directory>
   </VirtualHost>
   ```
3. Edite `C:\Windows\System32\drivers\etc\hosts` (como administrador):
   ```
   127.0.0.1    empreendedormei.local
   ```
4. Reinicie o Apache
5. Acesse: `http://empreendedormei.local/a.php`

## 🔒 Segurança em Desenvolvimento

### Desabilitar Exibição de Erros em Produção

No arquivo `php.ini`:
```ini
display_errors = Off
log_errors = On
error_log = "C:/xampp/php/logs/php_error.log"
```

### Configurar Timezone

No arquivo `php.ini`:
```ini
date.timezone = "America/Sao_Paulo"
```

## 📊 Verificar Logs

### Logs do Apache
```
C:\xampp\apache\logs\error.log
```

### Logs do PHP
```
C:\xampp\php\logs\php_error.log
```

### Logs de Acesso do Apache
```
C:\xampp\apache\logs\access.log
```

## ✅ Checklist de Instalação

- [ ] XAMPP instalado e funcionando
- [ ] Apache iniciado no XAMPP Control Panel
- [ ] Extensão `curl` habilitada no PHP
- [ ] Projeto localizado em `C:\xampp\htdocs\empreendedormei`
- [ ] Página `a.php` acessível via navegador
- [ ] Conexão com internet (para CDNs e APIs)
- [ ] Console do navegador sem erros (F12)

## 🆘 Suporte

### Recursos Úteis

1. **Documentação XAMPP**: https://www.apachefriends.org/docs/
2. **Documentação PHP**: https://www.php.net/docs.php
3. **Documentação Vue.js**: https://vuejs.org/
4. **Documentação Tailwind CSS**: https://tailwindcss.com/docs

### Comandos Úteis

#### Verificar versão do PHP
```bash
php -v
```

#### Verificar extensões PHP
```bash
php -m
```

#### Testar conexão cURL
Crie um arquivo `test-curl.php`:
```php
<?php
if (function_exists('curl_version')) {
    echo "cURL está habilitado!";
    print_r(curl_version());
} else {
    echo "cURL NÃO está habilitado!";
}
?>
```
Acesse: `http://localhost/empreendedormei/test-curl.php`

---

**Última atualização**: Janeiro 2025  
**Versão do Guia**: 1.0.0

